Scriptname SKDP_WaterExit extends activemagiceffect  
{Adds blessing perk; removes water effect and replaces NPC clothes when on land}

Faction Property _LoveForSkinnydippersSKDP Auto
Weapon Property DummyItem Auto
Spell Property _2ndGenLandSpellSKDP Auto
Spell Property _SkinnydipPerkSKDP Auto
Spell Property WaterSpell Auto ; first generation does not replace the land spell on water exit, the second generation does
Bool Property ReplaceLandSpell = False Auto ; Set to True only for the Second Generation Enchantment (received when one disenchants the Nereid's Ring)

EVENT OnEffectStart(Actor akTarget, Actor akCaster)
	_SkinnydipPerkSKDP.cast(akCaster,akTarget)
endEVENT
	
EVENT OnEffectFinish(Actor akTarget, Actor akCaster)
	akTarget.Additem(DummyItem,1,true)
	akTarget.RemoveFromFaction(_LoveForSkinnydippersSKDP)
	akTarget.Removeitem(DummyItem,1,true) ; Adding and removing a weapon triggers the NPC to re-equip armor and weapons
	akTarget.RemoveSpell(WaterSpell)

	If ReplaceLandSpell 
		akTarget.AddSpell(_2ndGenLandSpellSKDP,false)

		; This is only necessary for NCPs who appear to loose constant/self spell effects when they replace their equipment on water exit
		; Player does not require this, but it does no harm.
		; If the effect is driven by an enchantment, this isn't needed--probably wouldn't do harm but not tested.
		; If the effect is a spell with a specified duration, like pool party, it isn't needed, but if it were used, the spell duration would not expire.
		; So, it is only needed for the second generation enchantment, when worn by an NPCs.

	EndIf
endEVENT


